<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use App\Models\Entry;
use App\Models\Publisher;
use App\Models\Tag;
use App\Models\Type;
use App\Models\User;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $user = User::factory()->create([
            'name' => 'Admin',
            'email' => 'admin@primo.business',
            'password' => bcrypt('cc4d8686639f5ab4b2b5818141c362c4'),
            'email_verified_at' => '2023-11-09 18:58:27',
            'created_at' => '2023-11-09 18:58:27',
            'updated_at' => '2023-11-09 18:58:27',
        ]);

        $publisher = Publisher::create([
            'name' => 'PWS',
            'notes' => 'My own publishing company',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        Publisher::create([
            'name' => 'Test',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);

        $tags = [];
        $tags[] = Tag::create([
            'title' => 'Educational',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Guide',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Short',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Action',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Adventure',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Drama',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Romance',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        $tags[] = Tag::create([
            'title' => 'Politics',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);

        $type = Type::create([
            'title' => 'Book',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);
        Type::create([
            'title' => 'Novel',
            'created_at' => '2023-11-09 18:58:48',
            'updated_at' => '2023-11-09 18:58:48',
        ]);

        $entry = new Entry([
            'title' => 'Be Perfect In English',
            'description' => 'Be fluent in English after reading this book.',
            'pages' => 223,
            'start_date' => '2016-01-01',
            'end_date' => '2017-01-01',
            'publish_date' => '2018-01-01',
            'notes' => 'This is my very own book!',
            'cover' => 'test-book-cover.jpg',
            'created_at' => '2023-11-09 19:12:17',
            'updated_at' => '2023-11-09 19:12:17',
        ]);
        $entry->type()->associate($type);
        $entry->publisher()->associate($publisher);
        $entry->save();
        $entry->tags()->attach([$tags[0]->id, $tags[1]->id]);

        $entry2 = new Entry([
            'title' => 'How to be a successful Tyrant',
            'description' => null,
            'pages' => 88,
            'start_date' => '2022-01-01',
            'end_date' => null,
            'publish_date' => null,
            'notes' => null,
            'cover' => null,
            'created_at' => '2025-02-07 23:31:01',
            'updated_at' => '2025-02-07 23:31:01',
        ]);
        $entry2->type()->associate($type);
        $entry2->publisher()->associate($publisher);
        $entry2->save();
        $entry2->tags()->attach([$tags[0]->id, $tags[1]->id, $tags[7]->id]);
    }
}
